#pragma once
#include "stdafx.h"

using namespace std;

template <class Type>
class Environment
{
	public:
		Particle<Type> * particle;

		long int quantity;
		float mass;
		float density;
	    float pressure;
		float k; //cp/cv

		string name;
		Environment() {}

		Environment(long int q, float m, float d, float p, float kk, string n = "Unnamed environment")
		{
			quantity = q;
			mass = m;
			density = d;
			pressure = p;
			k = kk;
			name = n;

			particle = new Particle<Type>[quantity];
			//
			//particle[0].setPosition(0.00, 0.2, 0);
			int x = 0;

			float r = 0.01;
			float s3 = powf(quantity, 1 / 3.0);
			float a = -s3/2*r;
			float b = -s3/2*r;
			float c = 0.02;

			int dx = floor(s3);
			int dz = dx;
			int dy = floor(quantity / (dx*dz));

			for (int i = 0; i < dx; i++)
			{
				a = -s3/2*r;
				b += r;
				for (int j = 0; j < dz; j++)
				{
					for (int o = 0; o < dy; o++)
					{
						particle[x++].setPosition(0 + a, c + 2*(rand())*r / RAND_MAX, 0 + b);
					}

					a += r;
				}
			}
			//


			////Setting up sizes of the cube
			//float dx, x;
			//float dy, y;
			//float dz, z;

			//modf(pow(q, ((float)1.0) / (float(3.0))), &dx);
			//modf(pow(q - dx, ((float)1.0) / (float(2.0))), &dy);
			//dz = q / (dx*dy);
			//
			//long int i = 0;
			////Setting up positions of particles 
			//for (x = 0; x < dx; x++)
			//{
			//	for (y = 0; y < dy; y++)
			//	{
			//		for (z = 0; z < dz; z++)
			//		{						
			//			a[i].setPosition(x, y, z);
			//			i++;
			//		}
			//	}
			//}
		}

		~Environment()
		{
			delete[] particle;
		}

		friend ostream &operator << (ostream &os, const Environment &e)
		{
			cout << "----------------------------" << endl;
			cout << e.name << endl;
			cout << "----------------------------" << endl;
			cout << "Quantity of particles:\t" << e.quantity << endl;
			cout << "Particle mass:\t\t" << e.mass << endl;
			cout << "Density:\t\t" << e.density << endl;
			cout << "Pressure:\t\t" << e.pressure << endl;
			cout << "cp / cv:\t\t" << e.k << endl << endl;

			for (int i = 0; i < e.quantity; i++)
			{
				os << "Particle no: " << i+1 << endl;
				os << e.particle[i] << endl;
			}

			return os;
		}

		Environment &operator = (const Environment &e)
		{
			quantity = e.quantity;
			mass = e.mass;
			density = e.density;
			pressure = e.pressure;
			k = e.k;
			name = e.name;
			
			particle = new Particle<Type>[e.quantity];

			for (int i = 0; i < e.quantity; i++)
			{
				particle[i] = e.particle[i];
			}

			return *this;
		}
};
